############################################################################
#####################        function define     ###########################
############################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

error.bar <- function(x, y, upper, lower=upper, length=0.1,...){
  if(length(x) != length(y) | length(y) !=length(lower) | length(lower) != length(upper))
    stop("vectors must be same length")
  arrows(x,y+upper, x, y-lower, angle=90, code=3, lwd=2, length=length, ...)
}

SpecificGene <- function(x,given_time,mean_cutoff){
    # find whether this gene is specific expressed in the given time point
    if (mean(x) >= mean_cutoff & x[given_time]==max(x)){
        return (x[given_time]/mean(x))
    }
    else{
        return (NA)
    }
}
############################################################################
#####################           read in data     ###########################
############################################################################
data <- read.table("../data/nsmb.2660-S2.txt",header=T,row.names=1)
Oocyte <- 1:3; Zygote <- 4:6; cell2 <- 7:12; cell4 <- 13:24; cell8 <- 25:44; Morula <- 45:60; MTE <- c(64,66,67,69,72,76:79);PTE <- c(61:63,65,68,70,71,81,82); PE <- c(84:90);EPI <- c(73:75,80,83);hESC0 <- 91:98; hESC10 <- 99:124
avg <- cbind(apply(data[,Oocyte],1,mean),apply(data[,Zygote],1,mean),apply(data[,cell2],1,mean),apply(data[,cell4],1,mean),apply(data[,cell8],1,mean),apply(data[,Morula],1,mean),apply(data[,MTE],1,mean),apply(data[,PTE],1,mean),apply(data[,PE],1,mean),apply(data[,EPI],1,mean),apply(data[,hESC0],1,mean),apply(data[,hESC10],1,mean))
time_point <- c("Oocyte","Zygote","X2cell","X4cell","X8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
dev_labels <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
colnames(avg) <- time_point
development_path <- time_point
dData <- log2(avg+1)

############################################################################
##############                      plot                  ##################
############################################################################
pdf("SFig3B.pdf",width=5,height=3.5)
genes <- c("MBD3L2","MBD3L3","MBD3L4","MBD3L5","ZSCAN4")
cols <- cccol[1:5]
names(cols) <- genes
plot(seq(12),seq(12),type="n",ylim=c(0,1000),main="Human Development",ylab="fpkm",xaxt="n",las=2,xlab="")
axis(side=1,1:length(dev_labels),dev_labels,las=2)
for(each in genes){
    plot_data <- as.vector(avg[each,time_point])
    points(seq(length(plot_data)),as.vector(plot_data),type="l",col=cols[each],lwd=2)
}
legend("topright",genes,col=cols,lty=1,bty="n",lwd=2)
dev.off()